# SuperTux 0.6.0 browser backport

This is a convenience file to easily reproduce the WASM builds for SuperTux
releases before 0.6.3. It is maintained solely by Semphris, not by the entire
SuperTux development team. However, you can reach me through the team's contact
at [https://supertux.org/contact.html].

## Building

Running the `build.sh` script will use Docker to create the WASM builds. Only
Docker and an internet connection are required for the build.

The script will put the artifacts in a folder called [`build`](build/).

## Hosting

You need a web server to host this file; simply browsing with the `file://`
protocol will not work. You may use a local webserver, or anything that speaks
HTTP.

Some newer versions of SuperTux require two additional headers; they are not
needed for this version.

## Known issues

- Unlike in v0.6.3 and later, progress is not saved, and data cannot be
  downloaded or uploaded. Use newer versions of SuperTux to enjoy those
  features. Alternatively, feel free to contribute :)
- Add-ons are not supported (cURL is not supported with Emscripten; it would
  need a new implementation)

## Patch details

A possibly incomplete list of changes that were done:

- The `CMakeLists.txt` file was adapted to use Emscripten's port of various
  dependencies.
- The add-on downloader has been disabled entirely.
- Some errors appear with modern compilers, mostly related to headers (missing,
  mistyped, or with clashing symbols).
- Some C++ objects that are needed for the whole execution of the game that were
  declared and held on the stack have been set to static. This prevents them
  from being destroyed when Emscripten simulates throwing an exception to regain
  control of the main loop. It exits every scope up to the main function before
  `ScreenManager::loop()` starts getting called by Emscritpen directly.
- The Quit button on the main menu was removed.
- The main loop has been adapted to use Emscripten's mechanisms.
