# SuperTux 0.3.3 browser backport

This is a convenience file to easily reproduce the WASM builds for SuperTux
releases before 0.6.3. It is maintained solely by Semphris, not by the entire
SuperTux development team. However, you can reach me through the team's contact
at [https://supertux.org/contact.html].

## Building

Running the `build.sh` script will use Docker to create the WASM builds. Only
Docker and an internet connection are required for the build.

The script will put the artifacts in a folder called [`build`](build/).

## Hosting

You need a web server to host this file; simply browsing with the `file://`
protocol will not work. You may use a local webserver, or anything that speaks
HTTP.

Some newer versions of SuperTux require two additional headers; they are not
needed for this version.

## Known issues

- Tile graphics are broken. It doesn't prevent the game from working, it just
  looks horrible.
- Unlike in v0.6.3 and later, progress is not saved, and data cannot be
  downloaded or uploaded. Use newer versions of SuperTux to enjoy those
  features. Alternatively, feel free to contribute :)
- Some semi-transparent (fading) objects are rendered as fully opaque. This is
  a limitation of the SDL renderer on Emscripten.

## Patch details

A possibly incomplete list of changes that were done:

- The `CMakeLists.txt` file was adapted to use Emscripten's port of various
  dependencies, and a custom build of PhysFS.
- Tinygettext does not use SDL because some SDL symbols seems to be missing.
- Emscripten's port of SDL is apparently SDL 1.3, which is a Frankenstein
  monster between SDL 1.2 and 2.0. Some symbols were missing, or voluntarily
  replaced as no-ops by Emscripten; I had to remove or adapt the code
  accordingly.
- Speaking of main loop, it has been adapted to use Emscripten's mechanisms.
- Some errors appear with modern compilers. Some missing includes and clashing
  symbols were fixed; most notably, Squirrel's `type()` clashed with something
  in the standard library, so it had to be renamed.
- The Quit button on the main menu was removed.
- Emscripten's SDL has a problem with RWops and SDL_Image which only says
  "unknown SDL_emscripten error"; the code has been adapted to use string paths
  instead.

