#!/bin/sh

set -e

docker build . -t supertux-wasm-0.1.3
CONTAINER=`docker run --pull=never -id --rm supertux-wasm-0.1.3`
rm -r build/ || true
zip -r source *
mkdir -p build/
mv source.zip build/
cp files/* build/
docker cp $CONTAINER:/supertux/src/supertux build/supertux.js
docker cp $CONTAINER:/supertux/src/supertux.wasm build/
docker cp $CONTAINER:/supertux/src/supertux.data build/
docker cp $CONTAINER:/supertux/data/images/icon.xpm build/
convert build/icon.xpm build/supertux.ico
rm build/icon.xpm
docker kill $CONTAINER
